<?php

namespace Database\Seeders;

use App\Models\LicensedIn;
use Illuminate\Database\Seeder;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class UsStatesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $states = [
            ['name' => 'Alabama',          'short' => 'AL'],
            ['name' => 'Alaska',           'short' => 'AK'],
            ['name' => 'Arizona',          'short' => 'AZ'],
            ['name' => 'Arkansas',         'short' => 'AR'],
            ['name' => 'California',       'short' => 'CA'],
            ['name' => 'Colorado',         'short' => 'CO'],
            ['name' => 'Connecticut',      'short' => 'CT'],
            ['name' => 'Delaware',         'short' => 'DE'],
            ['name' => 'Florida',          'short' => 'FL'],
            ['name' => 'Georgia',          'short' => 'GA'],
            ['name' => 'Hawaii',           'short' => 'HI'],
            ['name' => 'Idaho',            'short' => 'ID'],
            ['name' => 'Illinois',         'short' => 'IL'],
            ['name' => 'Indiana',          'short' => 'IN'],
            ['name' => 'Iowa',             'short' => 'IA'],
            ['name' => 'Kansas',           'short' => 'KS'],
            ['name' => 'Kentucky',         'short' => 'KY'],
            ['name' => 'Louisiana',        'short' => 'LA'],
            ['name' => 'Maine',            'short' => 'ME'],
            ['name' => 'Maryland',         'short' => 'MD'],
            ['name' => 'Massachusetts',    'short' => 'MA'],
            ['name' => 'Michigan',         'short' => 'MI'],
            ['name' => 'Minnesota',        'short' => 'MN'],
            ['name' => 'Mississippi',      'short' => 'MS'],
            ['name' => 'Missouri',         'short' => 'MO'],
            ['name' => 'Montana',          'short' => 'MT'],
            ['name' => 'Nebraska',         'short' => 'NE'],
            ['name' => 'Nevada',           'short' => 'NV'],
            ['name' => 'New Hampshire',    'short' => 'NH'],
            ['name' => 'New Jersey',       'short' => 'NJ'],
            ['name' => 'New Mexico',       'short' => 'NM'],
            ['name' => 'New York',         'short' => 'NY'],
            ['name' => 'North Carolina',   'short' => 'NC'],
            ['name' => 'North Dakota',     'short' => 'ND'],
            ['name' => 'Ohio',             'short' => 'OH'],
            ['name' => 'Oklahoma',         'short' => 'OK'],
            ['name' => 'Oregon',           'short' => 'OR'],
            ['name' => 'Pennsylvania',     'short' => 'PA'],
            ['name' => 'Rhode Island',     'short' => 'RI'],
            ['name' => 'South Carolina',  'short' => 'SC'],
            ['name' => 'South Dakota',     'short' => 'SD'],
            ['name' => 'Tennessee',        'short' => 'TN'],
            ['name' => 'Texas',            'short' => 'TX'],
            ['name' => 'Utah',             'short' => 'UT'],
            ['name' => 'Vermont',          'short' => 'VT'],
            ['name' => 'Virginia',         'short' => 'VA'],
            ['name' => 'Washington',       'short' => 'WA'],
            ['name' => 'West Virginia',    'short' => 'WV'],
            ['name' => 'Wisconsin',        'short' => 'WI'],
            ['name' => 'Wyoming',          'short' => 'WY'],
            ['name' => 'State Of Residency', 'short' => 'SOR'],
        ];

        foreach ($states as $state) {
            LicensedIn::updateOrCreate(
                ['short' => $state['short']],
                ['name' => $state['name']]
            );
        }
    }
}
