import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../../../wayfinder'
/**
* @see \App\Filament\Resources\AllJobs\Pages\CreateAllJob::__invoke
* @see app/Filament/Resources/AllJobs/Pages/CreateAllJob.php:7
* @route '/recruiter/all-jobs/create'
*/
const CreateAllJob = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: CreateAllJob.url(options),
    method: 'get',
})

CreateAllJob.definition = {
    methods: ["get","head"],
    url: '/recruiter/all-jobs/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Filament\Resources\AllJobs\Pages\CreateAllJob::__invoke
* @see app/Filament/Resources/AllJobs/Pages/CreateAllJob.php:7
* @route '/recruiter/all-jobs/create'
*/
CreateAllJob.url = (options?: RouteQueryOptions) => {
    return CreateAllJob.definition.url + queryParams(options)
}

/**
* @see \App\Filament\Resources\AllJobs\Pages\CreateAllJob::__invoke
* @see app/Filament/Resources/AllJobs/Pages/CreateAllJob.php:7
* @route '/recruiter/all-jobs/create'
*/
CreateAllJob.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: CreateAllJob.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\AllJobs\Pages\CreateAllJob::__invoke
* @see app/Filament/Resources/AllJobs/Pages/CreateAllJob.php:7
* @route '/recruiter/all-jobs/create'
*/
CreateAllJob.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: CreateAllJob.url(options),
    method: 'head',
})

/**
* @see \App\Filament\Resources\AllJobs\Pages\CreateAllJob::__invoke
* @see app/Filament/Resources/AllJobs/Pages/CreateAllJob.php:7
* @route '/recruiter/all-jobs/create'
*/
const CreateAllJobForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: CreateAllJob.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\AllJobs\Pages\CreateAllJob::__invoke
* @see app/Filament/Resources/AllJobs/Pages/CreateAllJob.php:7
* @route '/recruiter/all-jobs/create'
*/
CreateAllJobForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: CreateAllJob.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\AllJobs\Pages\CreateAllJob::__invoke
* @see app/Filament/Resources/AllJobs/Pages/CreateAllJob.php:7
* @route '/recruiter/all-jobs/create'
*/
CreateAllJobForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: CreateAllJob.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

CreateAllJob.form = CreateAllJobForm

export default CreateAllJob