import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../../wayfinder'
/**
* @see \App\Filament\Resources\JobApplications\Pages\EditJobApplication::__invoke
* @see app/Filament/Resources/JobApplications/Pages/EditJobApplication.php:7
* @route '/recruiter/job-applications/{record}/edit'
*/
const EditJobApplication = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: EditJobApplication.url(args, options),
    method: 'get',
})

EditJobApplication.definition = {
    methods: ["get","head"],
    url: '/recruiter/job-applications/{record}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Filament\Resources\JobApplications\Pages\EditJobApplication::__invoke
* @see app/Filament/Resources/JobApplications/Pages/EditJobApplication.php:7
* @route '/recruiter/job-applications/{record}/edit'
*/
EditJobApplication.url = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { record: args }
    }

    if (Array.isArray(args)) {
        args = {
            record: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        record: args.record,
    }

    return EditJobApplication.definition.url
            .replace('{record}', parsedArgs.record.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Filament\Resources\JobApplications\Pages\EditJobApplication::__invoke
* @see app/Filament/Resources/JobApplications/Pages/EditJobApplication.php:7
* @route '/recruiter/job-applications/{record}/edit'
*/
EditJobApplication.get = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: EditJobApplication.url(args, options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\JobApplications\Pages\EditJobApplication::__invoke
* @see app/Filament/Resources/JobApplications/Pages/EditJobApplication.php:7
* @route '/recruiter/job-applications/{record}/edit'
*/
EditJobApplication.head = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: EditJobApplication.url(args, options),
    method: 'head',
})

/**
* @see \App\Filament\Resources\JobApplications\Pages\EditJobApplication::__invoke
* @see app/Filament/Resources/JobApplications/Pages/EditJobApplication.php:7
* @route '/recruiter/job-applications/{record}/edit'
*/
const EditJobApplicationForm = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: EditJobApplication.url(args, options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\JobApplications\Pages\EditJobApplication::__invoke
* @see app/Filament/Resources/JobApplications/Pages/EditJobApplication.php:7
* @route '/recruiter/job-applications/{record}/edit'
*/
EditJobApplicationForm.get = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: EditJobApplication.url(args, options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\JobApplications\Pages\EditJobApplication::__invoke
* @see app/Filament/Resources/JobApplications/Pages/EditJobApplication.php:7
* @route '/recruiter/job-applications/{record}/edit'
*/
EditJobApplicationForm.head = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: EditJobApplication.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

EditJobApplication.form = EditJobApplicationForm

export default EditJobApplication