import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../../../wayfinder'
/**
* @see \App\Filament\Resources\Specialities\Pages\ManageSpecialities::__invoke
* @see app/Filament/Resources/Specialities/Pages/ManageSpecialities.php:7
* @route '/recruiter/specialities'
*/
const ManageSpecialities = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: ManageSpecialities.url(options),
    method: 'get',
})

ManageSpecialities.definition = {
    methods: ["get","head"],
    url: '/recruiter/specialities',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Filament\Resources\Specialities\Pages\ManageSpecialities::__invoke
* @see app/Filament/Resources/Specialities/Pages/ManageSpecialities.php:7
* @route '/recruiter/specialities'
*/
ManageSpecialities.url = (options?: RouteQueryOptions) => {
    return ManageSpecialities.definition.url + queryParams(options)
}

/**
* @see \App\Filament\Resources\Specialities\Pages\ManageSpecialities::__invoke
* @see app/Filament/Resources/Specialities/Pages/ManageSpecialities.php:7
* @route '/recruiter/specialities'
*/
ManageSpecialities.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: ManageSpecialities.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\Specialities\Pages\ManageSpecialities::__invoke
* @see app/Filament/Resources/Specialities/Pages/ManageSpecialities.php:7
* @route '/recruiter/specialities'
*/
ManageSpecialities.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: ManageSpecialities.url(options),
    method: 'head',
})

/**
* @see \App\Filament\Resources\Specialities\Pages\ManageSpecialities::__invoke
* @see app/Filament/Resources/Specialities/Pages/ManageSpecialities.php:7
* @route '/recruiter/specialities'
*/
const ManageSpecialitiesForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: ManageSpecialities.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\Specialities\Pages\ManageSpecialities::__invoke
* @see app/Filament/Resources/Specialities/Pages/ManageSpecialities.php:7
* @route '/recruiter/specialities'
*/
ManageSpecialitiesForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: ManageSpecialities.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\Specialities\Pages\ManageSpecialities::__invoke
* @see app/Filament/Resources/Specialities/Pages/ManageSpecialities.php:7
* @route '/recruiter/specialities'
*/
ManageSpecialitiesForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: ManageSpecialities.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

ManageSpecialities.form = ManageSpecialitiesForm

export default ManageSpecialities