import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../wayfinder'
/**
* @see \App\Http\Controllers\JobDetailController::__invoke
* @see app/Http/Controllers/JobDetailController.php:10
* @route '/job/{slug}'
*/
const JobDetailController = (args: { slug: string | number } | [slug: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: JobDetailController.url(args, options),
    method: 'get',
})

JobDetailController.definition = {
    methods: ["get","head"],
    url: '/job/{slug}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\JobDetailController::__invoke
* @see app/Http/Controllers/JobDetailController.php:10
* @route '/job/{slug}'
*/
JobDetailController.url = (args: { slug: string | number } | [slug: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { slug: args }
    }

    if (Array.isArray(args)) {
        args = {
            slug: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        slug: args.slug,
    }

    return JobDetailController.definition.url
            .replace('{slug}', parsedArgs.slug.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\JobDetailController::__invoke
* @see app/Http/Controllers/JobDetailController.php:10
* @route '/job/{slug}'
*/
JobDetailController.get = (args: { slug: string | number } | [slug: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: JobDetailController.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\JobDetailController::__invoke
* @see app/Http/Controllers/JobDetailController.php:10
* @route '/job/{slug}'
*/
JobDetailController.head = (args: { slug: string | number } | [slug: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: JobDetailController.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\JobDetailController::__invoke
* @see app/Http/Controllers/JobDetailController.php:10
* @route '/job/{slug}'
*/
const JobDetailControllerForm = (args: { slug: string | number } | [slug: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: JobDetailController.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\JobDetailController::__invoke
* @see app/Http/Controllers/JobDetailController.php:10
* @route '/job/{slug}'
*/
JobDetailControllerForm.get = (args: { slug: string | number } | [slug: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: JobDetailController.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\JobDetailController::__invoke
* @see app/Http/Controllers/JobDetailController.php:10
* @route '/job/{slug}'
*/
JobDetailControllerForm.head = (args: { slug: string | number } | [slug: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: JobDetailController.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

JobDetailController.form = JobDetailControllerForm

export default JobDetailController