import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../wayfinder'
/**
* @see \App\Http\Controllers\ProfileController::uploadResume
* @see app/Http/Controllers/ProfileController.php:58
* @route '/resume/upload'
*/
export const uploadResume = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: uploadResume.url(options),
    method: 'post',
})

uploadResume.definition = {
    methods: ["post"],
    url: '/resume/upload',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\ProfileController::uploadResume
* @see app/Http/Controllers/ProfileController.php:58
* @route '/resume/upload'
*/
uploadResume.url = (options?: RouteQueryOptions) => {
    return uploadResume.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\ProfileController::uploadResume
* @see app/Http/Controllers/ProfileController.php:58
* @route '/resume/upload'
*/
uploadResume.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: uploadResume.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\ProfileController::uploadResume
* @see app/Http/Controllers/ProfileController.php:58
* @route '/resume/upload'
*/
const uploadResumeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: uploadResume.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\ProfileController::uploadResume
* @see app/Http/Controllers/ProfileController.php:58
* @route '/resume/upload'
*/
uploadResumeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: uploadResume.url(options),
    method: 'post',
})

uploadResume.form = uploadResumeForm

/**
* @see \App\Http\Controllers\ProfileController::edit
* @see app/Http/Controllers/ProfileController.php:12
* @route '/profile'
*/
export const edit = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(options),
    method: 'get',
})

edit.definition = {
    methods: ["get","head"],
    url: '/profile',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\ProfileController::edit
* @see app/Http/Controllers/ProfileController.php:12
* @route '/profile'
*/
edit.url = (options?: RouteQueryOptions) => {
    return edit.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\ProfileController::edit
* @see app/Http/Controllers/ProfileController.php:12
* @route '/profile'
*/
edit.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\ProfileController::edit
* @see app/Http/Controllers/ProfileController.php:12
* @route '/profile'
*/
edit.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: edit.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\ProfileController::edit
* @see app/Http/Controllers/ProfileController.php:12
* @route '/profile'
*/
const editForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\ProfileController::edit
* @see app/Http/Controllers/ProfileController.php:12
* @route '/profile'
*/
editForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\ProfileController::edit
* @see app/Http/Controllers/ProfileController.php:12
* @route '/profile'
*/
editForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

edit.form = editForm

/**
* @see \App\Http\Controllers\ProfileController::update
* @see app/Http/Controllers/ProfileController.php:30
* @route '/profile/update'
*/
export const update = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: update.url(options),
    method: 'post',
})

update.definition = {
    methods: ["post"],
    url: '/profile/update',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\ProfileController::update
* @see app/Http/Controllers/ProfileController.php:30
* @route '/profile/update'
*/
update.url = (options?: RouteQueryOptions) => {
    return update.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\ProfileController::update
* @see app/Http/Controllers/ProfileController.php:30
* @route '/profile/update'
*/
update.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: update.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\ProfileController::update
* @see app/Http/Controllers/ProfileController.php:30
* @route '/profile/update'
*/
const updateForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\ProfileController::update
* @see app/Http/Controllers/ProfileController.php:30
* @route '/profile/update'
*/
updateForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(options),
    method: 'post',
})

update.form = updateForm

const ProfileController = { uploadResume, edit, update }

export default ProfileController