import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../../wayfinder'
/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\AuthUiEnhancerLogin::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/AuthUiEnhancerLogin.php:7
* @route '/recruiter/login'
*/
const AuthUiEnhancerLogin = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: AuthUiEnhancerLogin.url(options),
    method: 'get',
})

AuthUiEnhancerLogin.definition = {
    methods: ["get","head"],
    url: '/recruiter/login',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\AuthUiEnhancerLogin::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/AuthUiEnhancerLogin.php:7
* @route '/recruiter/login'
*/
AuthUiEnhancerLogin.url = (options?: RouteQueryOptions) => {
    return AuthUiEnhancerLogin.definition.url + queryParams(options)
}

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\AuthUiEnhancerLogin::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/AuthUiEnhancerLogin.php:7
* @route '/recruiter/login'
*/
AuthUiEnhancerLogin.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: AuthUiEnhancerLogin.url(options),
    method: 'get',
})

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\AuthUiEnhancerLogin::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/AuthUiEnhancerLogin.php:7
* @route '/recruiter/login'
*/
AuthUiEnhancerLogin.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: AuthUiEnhancerLogin.url(options),
    method: 'head',
})

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\AuthUiEnhancerLogin::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/AuthUiEnhancerLogin.php:7
* @route '/recruiter/login'
*/
const AuthUiEnhancerLoginForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: AuthUiEnhancerLogin.url(options),
    method: 'get',
})

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\AuthUiEnhancerLogin::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/AuthUiEnhancerLogin.php:7
* @route '/recruiter/login'
*/
AuthUiEnhancerLoginForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: AuthUiEnhancerLogin.url(options),
    method: 'get',
})

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\AuthUiEnhancerLogin::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/AuthUiEnhancerLogin.php:7
* @route '/recruiter/login'
*/
AuthUiEnhancerLoginForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: AuthUiEnhancerLogin.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

AuthUiEnhancerLogin.form = AuthUiEnhancerLoginForm

export default AuthUiEnhancerLogin