import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../../wayfinder'
/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\AuthUiEnhancerRegister::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/AuthUiEnhancerRegister.php:7
* @route '/recruiter/register'
*/
const AuthUiEnhancerRegister = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: AuthUiEnhancerRegister.url(options),
    method: 'get',
})

AuthUiEnhancerRegister.definition = {
    methods: ["get","head"],
    url: '/recruiter/register',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\AuthUiEnhancerRegister::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/AuthUiEnhancerRegister.php:7
* @route '/recruiter/register'
*/
AuthUiEnhancerRegister.url = (options?: RouteQueryOptions) => {
    return AuthUiEnhancerRegister.definition.url + queryParams(options)
}

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\AuthUiEnhancerRegister::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/AuthUiEnhancerRegister.php:7
* @route '/recruiter/register'
*/
AuthUiEnhancerRegister.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: AuthUiEnhancerRegister.url(options),
    method: 'get',
})

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\AuthUiEnhancerRegister::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/AuthUiEnhancerRegister.php:7
* @route '/recruiter/register'
*/
AuthUiEnhancerRegister.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: AuthUiEnhancerRegister.url(options),
    method: 'head',
})

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\AuthUiEnhancerRegister::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/AuthUiEnhancerRegister.php:7
* @route '/recruiter/register'
*/
const AuthUiEnhancerRegisterForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: AuthUiEnhancerRegister.url(options),
    method: 'get',
})

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\AuthUiEnhancerRegister::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/AuthUiEnhancerRegister.php:7
* @route '/recruiter/register'
*/
AuthUiEnhancerRegisterForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: AuthUiEnhancerRegister.url(options),
    method: 'get',
})

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\AuthUiEnhancerRegister::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/AuthUiEnhancerRegister.php:7
* @route '/recruiter/register'
*/
AuthUiEnhancerRegisterForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: AuthUiEnhancerRegister.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

AuthUiEnhancerRegister.form = AuthUiEnhancerRegisterForm

export default AuthUiEnhancerRegister