import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../../../wayfinder'
/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\PasswordReset\AuthUiEnhancerResetPassword::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/PasswordReset/AuthUiEnhancerResetPassword.php:7
* @route '/recruiter/password-reset/reset'
*/
const AuthUiEnhancerResetPassword = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: AuthUiEnhancerResetPassword.url(options),
    method: 'get',
})

AuthUiEnhancerResetPassword.definition = {
    methods: ["get","head"],
    url: '/recruiter/password-reset/reset',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\PasswordReset\AuthUiEnhancerResetPassword::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/PasswordReset/AuthUiEnhancerResetPassword.php:7
* @route '/recruiter/password-reset/reset'
*/
AuthUiEnhancerResetPassword.url = (options?: RouteQueryOptions) => {
    return AuthUiEnhancerResetPassword.definition.url + queryParams(options)
}

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\PasswordReset\AuthUiEnhancerResetPassword::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/PasswordReset/AuthUiEnhancerResetPassword.php:7
* @route '/recruiter/password-reset/reset'
*/
AuthUiEnhancerResetPassword.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: AuthUiEnhancerResetPassword.url(options),
    method: 'get',
})

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\PasswordReset\AuthUiEnhancerResetPassword::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/PasswordReset/AuthUiEnhancerResetPassword.php:7
* @route '/recruiter/password-reset/reset'
*/
AuthUiEnhancerResetPassword.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: AuthUiEnhancerResetPassword.url(options),
    method: 'head',
})

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\PasswordReset\AuthUiEnhancerResetPassword::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/PasswordReset/AuthUiEnhancerResetPassword.php:7
* @route '/recruiter/password-reset/reset'
*/
const AuthUiEnhancerResetPasswordForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: AuthUiEnhancerResetPassword.url(options),
    method: 'get',
})

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\PasswordReset\AuthUiEnhancerResetPassword::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/PasswordReset/AuthUiEnhancerResetPassword.php:7
* @route '/recruiter/password-reset/reset'
*/
AuthUiEnhancerResetPasswordForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: AuthUiEnhancerResetPassword.url(options),
    method: 'get',
})

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\PasswordReset\AuthUiEnhancerResetPassword::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/PasswordReset/AuthUiEnhancerResetPassword.php:7
* @route '/recruiter/password-reset/reset'
*/
AuthUiEnhancerResetPasswordForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: AuthUiEnhancerResetPassword.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

AuthUiEnhancerResetPassword.form = AuthUiEnhancerResetPasswordForm

export default AuthUiEnhancerResetPassword