import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../../wayfinder'
/**
* @see \App\Filament\Resources\RemoteStatuses\Pages\ManageRemoteStatuses::__invoke
* @see app/Filament/Resources/RemoteStatuses/Pages/ManageRemoteStatuses.php:7
* @route '/recruiter/remote-statuses'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/recruiter/remote-statuses',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Filament\Resources\RemoteStatuses\Pages\ManageRemoteStatuses::__invoke
* @see app/Filament/Resources/RemoteStatuses/Pages/ManageRemoteStatuses.php:7
* @route '/recruiter/remote-statuses'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Filament\Resources\RemoteStatuses\Pages\ManageRemoteStatuses::__invoke
* @see app/Filament/Resources/RemoteStatuses/Pages/ManageRemoteStatuses.php:7
* @route '/recruiter/remote-statuses'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\RemoteStatuses\Pages\ManageRemoteStatuses::__invoke
* @see app/Filament/Resources/RemoteStatuses/Pages/ManageRemoteStatuses.php:7
* @route '/recruiter/remote-statuses'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Filament\Resources\RemoteStatuses\Pages\ManageRemoteStatuses::__invoke
* @see app/Filament/Resources/RemoteStatuses/Pages/ManageRemoteStatuses.php:7
* @route '/recruiter/remote-statuses'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\RemoteStatuses\Pages\ManageRemoteStatuses::__invoke
* @see app/Filament/Resources/RemoteStatuses/Pages/ManageRemoteStatuses.php:7
* @route '/recruiter/remote-statuses'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\RemoteStatuses\Pages\ManageRemoteStatuses::__invoke
* @see app/Filament/Resources/RemoteStatuses/Pages/ManageRemoteStatuses.php:7
* @route '/recruiter/remote-statuses'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

const remoteStatuses = {
    index: Object.assign(index, index),
}

export default remoteStatuses