import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../../wayfinder'
/**
* @see \App\Filament\Resources\Specialities\Pages\ManageSpecialities::__invoke
* @see app/Filament/Resources/Specialities/Pages/ManageSpecialities.php:7
* @route '/recruiter/specialities'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/recruiter/specialities',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Filament\Resources\Specialities\Pages\ManageSpecialities::__invoke
* @see app/Filament/Resources/Specialities/Pages/ManageSpecialities.php:7
* @route '/recruiter/specialities'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Filament\Resources\Specialities\Pages\ManageSpecialities::__invoke
* @see app/Filament/Resources/Specialities/Pages/ManageSpecialities.php:7
* @route '/recruiter/specialities'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\Specialities\Pages\ManageSpecialities::__invoke
* @see app/Filament/Resources/Specialities/Pages/ManageSpecialities.php:7
* @route '/recruiter/specialities'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Filament\Resources\Specialities\Pages\ManageSpecialities::__invoke
* @see app/Filament/Resources/Specialities/Pages/ManageSpecialities.php:7
* @route '/recruiter/specialities'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\Specialities\Pages\ManageSpecialities::__invoke
* @see app/Filament/Resources/Specialities/Pages/ManageSpecialities.php:7
* @route '/recruiter/specialities'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\Specialities\Pages\ManageSpecialities::__invoke
* @see app/Filament/Resources/Specialities/Pages/ManageSpecialities.php:7
* @route '/recruiter/specialities'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

const specialities = {
    index: Object.assign(index, index),
}

export default specialities